<?php

/*
+--------------------------------------------------------------------------
|   Invision Power Board v1.2
|   ========================================
|   by Matthew Mecham
|   (c) 2001 - 2003 Invision Power Services
|   http://www.invisionpower.com
|   ========================================
|   Web: http://www.invisionboard.com
|   Email: matt@invisionpower.com
|   Licence Info: http://www.invisionboard.com/?license
+---------------------------------------------------------------------------
|
|   > Statistical functions
|   > Module written by Matt Mecham
|   > Date started: 4th July 2002
|
|	> Module Version Number: 1.0.0
+--------------------------------------------------------------------------
*/




$idx = new ad_stats();


class ad_stats {

	var $base_url;
	var $month_names = array();

	function ad_stats()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		//---------------------------------------
		// Kill globals - globals bad, Homer good.
		//---------------------------------------
		
		$tmp_in = array_merge( $_GET, $_POST, $_COOKIE );
		
		foreach ( $tmp_in as $k => $v )
		{
			unset($$k);
		}
		
		//---------------------------------------
		
		$this->month_names = array( 1 => 'һ', '', ''     , ''  , ''     , '',
										 ''   , ''  , '' , 'ʮ', 'ʮһ', 'ʮ'
								  );

		switch($IN['code'])
		{
			case 'show_reg':
				$this->result_screen('reg');
				break;
				
			case 'show_topic':
				$this->result_screen('topic');
				break;
					
			case 'topic':
				$this->main_screen('topic');
				break;
			
			//-----------------------
			
			case 'show_post':
				$this->result_screen('post');
				break;
					
			case 'post':
				$this->main_screen('post');
				break;
			
			//-----------------------
			
			case 'show_msg':
				$this->result_screen('msg');
				break;
					
			case 'msg':
				$this->main_screen('msg');
				break;
				
				//-----------------------
			
			case 'show_views':
				$this->show_views();
				break;
					
			case 'views':
				$this->main_screen('views');
				break;
			
			//-----------------------
			
			default:
				$this->main_screen('reg');
				break;
		}
		
	}
	
	//select forum_id, SUM(views)from ibf_topics group by forum_id order by forum_id
	
	//+---------------------------------------------------------------------------------
	//| Results screen
	//+---------------------------------------------------------------------------------
	
	function show_views()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$ADMIN->page_title = "ͳĽ";
		
		$ADMIN->page_detail = "ʾͳ";
		
		//+---------------------
		
		if ( ! checkdate($IN['to_month']   ,$IN['to_day']   ,$IN['to_year']) )
		{
			$ADMIN->error(" 'ڣ' ʱ䲻ȷԡ");
		}
		
		if ( ! checkdate($IN['from_month'] ,$IN['from_day'] ,$IN['from_year']) )
		{
			$ADMIN->error(" 'ʼڣ' ʱ䲻ȷԡ");
		}
		
		//+---------------------
		
		$to_time   = mktime(12 ,0 ,0 ,$IN['to_month']   ,$IN['to_day']   ,$IN['to_year']  );
		$from_time = mktime(12 ,0 ,0 ,$IN['from_month'] ,$IN['from_day'] ,$IN['from_year']);
		
		
		$human_to_date   = getdate($to_time);
		$human_from_date = getdate($from_time);
		
		$DB->query("SELECT SUM(t.views) as result_count, t.forum_id, f.name as result_name
				           FROM ibf_topics t, ibf_forums f
				           WHERE t.start_date > '$from_time'
				           AND t.start_date < '$to_time'
				           AND t.forum_id=f.id
				           GROUP BY t.forum_id
				           ORDER BY result_count {$IN['sortby']}");
				           
		$running_total = 0;
		$max_result    = 0;
		
		$results       = array();
		
		$SKIN->td_header[] = array( ""   , "40%" );
		$SKIN->td_header[] = array( ""  , "50%" );
		$SKIN->td_header[] = array( ""   , "10%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( ""
										    ." ({$human_from_date['mday']} {$this->month_names[$human_from_date['mon']]} {$human_from_date['year']} to"
										    ." {$human_to_date['mday']} {$this->month_names[$human_to_date['mon']]} {$human_to_date['year']})"
										  );
		
		if ( $DB->get_num_rows() )
		{
		
			while ($row = $DB->fetch_row() )
			{
			
				if ( $row['result_count'] >  $max_result )
				{
					$max_result = $row['result_count'];
				}
				
				$running_total += $row['result_count'];
			
				$results[] = array(
									 'result_name'     => $row['result_name'],
									 'result_count'    => $row['result_count'],
								  );
								  
			}
			
			foreach( $results as $pOOp => $data )
			{
			
    			$img_width = intval( ($data['result_count'] / $max_result) * 100 - 8);
    			
    			if ($img_width < 1)
    			{
    				$img_width = 1;
    			}
    			
    			$img_width .= '%';
    			
    			$ADMIN->html .= $SKIN->add_td_row( array( $data['result_name'],
    													  "<img src='{$SKIN->img_url}/bar_left.gif' border='0' width='4' height='11' align='middle' alt=''><img src='{$SKIN->img_url}/bar.gif' border='0' width='$img_width' height='11' align='middle' alt=''><img src='{$SKIN->img_url}/bar_right.gif' border='0' width='4' height='11' align='middle' alt=''>",
												  		  "<center>".$data['result_count']."</center>",
									             )      );
			}
			
			$ADMIN->html .= $SKIN->add_td_row( array( '&nbsp;',
													 "<div align='right'><b></b></div>",
													 "<center><b>".$running_total."</b></center>",
											)      );
		
		}
		else
		{
			$ADMIN->html .= $SKIN->add_td_basic( "ûҵ", "center" );
		}
		
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
		
	}
	
	//+---------------------------------------------------------------------------------
	//| Results screen
	//+---------------------------------------------------------------------------------
	
	function result_screen($mode='reg')
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$ADMIN->page_title = "ͳĽ";
		
		$ADMIN->page_detail = "&nbsp;";
		
		//+---------------------
		
		if ( ! checkdate($IN['to_month']   ,$IN['to_day']   ,$IN['to_year']) )
		{
			$ADMIN->error(" 'ڣ' ʱ䲻ȷԡ");
		}
		
		if ( ! checkdate($IN['from_month'] ,$IN['from_day'] ,$IN['from_year']) )
		{
			$ADMIN->error(" 'ʼڣ' ʱ䲻ȷԡ");
		}
		
		//+---------------------
		
		$to_time   = mktime(12 ,0 ,0 ,$IN['to_month']   ,$IN['to_day']   ,$IN['to_year']  );
		$from_time = mktime(12 ,0 ,0 ,$IN['from_month'] ,$IN['from_day'] ,$IN['from_year']);
		
		
		$human_to_date   = getdate($to_time);
		$human_from_date = getdate($from_time);
		
		//+---------------------
		
		if ($mode == 'reg')
		{
			$table     = 'עͳ';
			
			$sql_table = 'ibf_members';
			$sql_field = 'user_regdate';
			
			$ADMIN->page_detail = "ʾעʹ (ע⣺ʱ GMT)";
		}
		else if ($mode == 'topic')
		{
			$table     = 'ͳ';
			
			$sql_table = 'ibf_topics';
			$sql_field = 'start_date';
			
			$ADMIN->page_detail = "ʾ (ע⣺ʱ GMT)";
		}
		else if ($mode == 'post')
		{
			$table     = 'ͳ';
			
			$sql_table = 'ibf_posts';
			$sql_field = 'post_date';
			
			$ADMIN->page_detail = "ʾ (ע⣺ʱ GMT)";
		}
		else if ($mode == 'msg')
		{
			$table     = 'PM ͳ';
			
			$sql_table = 'ibf_messages';
			$sql_field = 'msg_date';
			
			$ADMIN->page_detail = "ʾ͵ѶϢ (ע⣺ʱ GMT)";
		}
		
	  
	  	switch ($IN['timescale'])
	  	{
	  		case 'ÿ':
	  			$sql_date = "%w %U %m %Y";
		  		$php_date = "F jS - Y";
		  		break;
		  		
		  	case 'ÿ':
		  		$sql_date = "%m %Y";
		  	    $php_date = "F Y";
		  	    break;
		  	    
		  	default:
		  		// weekly
		  		$sql_date = "%U %Y";
		  		$php_date = " [F Y]";
		  		break;
		}		
	  
		$DB->query("SELECT MAX($sql_field) as result_maxdate,
				           COUNT(*) as result_count,
				           DATE_FORMAT(from_unixtime($sql_field),'$sql_date') AS result_time
				           FROM $sql_table
				           WHERE $sql_field > '$from_time'
				           AND $sql_field < '$to_time'
				           GROUP BY result_time
				           ORDER BY $sql_field {$IN['sortby']}");
				           
		$running_total = 0;
		$max_result    = 0;
		
		$results       = array();
		
		$SKIN->td_header[] = array( ""    , "20%" );
		$SKIN->td_header[] = array( ""  , "70%" );
		$SKIN->td_header[] = array( ""   , "10%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( ucfirst($IN['timescale'])
										    ." ".$table
										    ." ({$human_from_date['mday']} {$this->month_names[$human_from_date['mon']]} {$human_from_date['year']} "
										    ." {$human_to_date['mday']} {$this->month_names[$human_to_date['mon']]} {$human_to_date['year']})"
										  );
		
		if ( $DB->get_num_rows() )
		{
		
			while ($row = $DB->fetch_row() )
			{
			
				if ( $row['result_count'] >  $max_result )
				{
					$max_result = $row['result_count'];
				}
				
				$running_total += $row['result_count'];
			
				$results[] = array(
									 'result_maxdate'  => $row['result_maxdate'],
									 'result_count'    => $row['result_count'],
									 'result_time'     => $row['result_time'],
								  );
								  
			}
			
			foreach( $results as $pOOp => $data )
			{
			
    			$img_width = intval( ($data['result_count'] / $max_result) * 100 - 8);
    			
    			if ($img_width < 1)
    			{
    				$img_width = 1;
    			}
    			
    			$img_width .= '%';
    			
    			if ($IN['timescale'] == 'ÿ')
    			{
    				$date = "Week #".strftime("%W", $data['result_maxdate']) . date( $php_date, $data['result_maxdate'] );
    			}
    			else
    			{
    				$date = date( $php_date, $data['result_maxdate'] );
    			}
    			
    			$ADMIN->html .= $SKIN->add_td_row( array( $date,
    													  "<img src='{$SKIN->img_url}/bar_left.gif' border='0' width='4' height='11' align='middle' alt=''><img src='{$SKIN->img_url}/bar.gif' border='0' width='$img_width' height='11' align='middle' alt=''><img src='{$SKIN->img_url}/bar_right.gif' border='0' width='4' height='11' align='middle' alt=''>",
												  		  "<center>".$data['result_count']."</center>",
									             )      );
			}
			
			$ADMIN->html .= $SKIN->add_td_row( array( '&nbsp;',
													 "<div align='right'><b></b></div>",
													 "<center><b>".$running_total."</b></center>",
											)      );
		
		}
		else
		{
			$ADMIN->html .= $SKIN->add_td_basic( "ûҵ", "center" );
		}
		
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
		
	}
	
	//+---------------------------------------------------------------------------------
	//| Date selection screen
	//+---------------------------------------------------------------------------------
	
	function main_screen($mode='reg')
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$ADMIN->page_title = "ͳ";
		
		$ADMIN->page_detail = "涩ڷΧѡ<br>ע⣺ͳϿеѶģῼǵɾ£ȵȡ";
		
		if ($mode == 'reg')
		{
			$form_code = 'show_reg';
			
			$table     = 'עͳ';
		}
		else if ($mode == 'topic')
		{
			$form_code = 'show_topic';
			
			$table     = 'ͳ';
		}
		else if ($mode == 'post')
		{
			$form_code = 'show_post';
			
			$table     = 'ͳ';
		}
		else if ($mode == 'msg')
		{
			$form_code = 'show_msg';
			
			$table     = 'PM ͳ';
		}
		else if ($mode == 'views')
		{
			$form_code = 'show_views';
			
			$table     = 'ͳ';
		}
		
		
		$old_date = getdate(time() - (3600 * 24 * 90));
		$new_date = getdate(time() + (3600 * 24));
		
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , $form_code  ),
												  2 => array( 'act'   , 'stats'     ),
									     )      );
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( $table );
		
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʼ</b>" ,
												  $SKIN->form_dropdown( "from_month" , $this->make_month(), $old_date['mon']  ).'&nbsp;&nbsp;'.
												  $SKIN->form_dropdown( "from_day"   , $this->make_day()  , $old_date['mday'] ).'&nbsp;&nbsp;'.
												  $SKIN->form_dropdown( "from_year"  , $this->make_year() , $old_date['year'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b></b>" ,
												  $SKIN->form_dropdown( "to_month" , $this->make_month(), $new_date['mon']  ).'&nbsp;&nbsp;'.
												  $SKIN->form_dropdown( "to_day"   , $this->make_day()  , $new_date['mday'] ).'&nbsp;&nbsp;'.
												  $SKIN->form_dropdown( "to_year"  , $this->make_year() , $new_date['year'] )
									     )      );
		
		if ($mode != 'views')
		{
			$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʱ</b>" ,
													  $SKIN->form_dropdown( "timescale" , array( 0 => array( 'ÿ', 'ÿ'), 1 => array( 'ÿ', 'ÿ' ), 2 => array( 'ÿ', 'ÿ' ) ) )
											 )      );
		}
						     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b></b>" ,
												  $SKIN->form_dropdown( "sortby" , array( 0 => array( 'asc', ' - ǰ'), 1 => array( 'desc', ' - ǰ' ) ), 'desc' )
									     )      );
									     									     
		$ADMIN->html .= $SKIN->end_form("ʾ");
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
		
		
	}
	
	//+---------------------------------------------------------------------------------
	
	function make_year()
	{
		$time_now = getdate();
		
		$return = array();
		
		$start_year = 2002;
		
		$latest_year = intval($time_now['year']);
		
		if ($latest_year == $start_year)
		{
			$start_year -= 1;
		}
		
		for ( $y = $start_year; $y <= $latest_year; $y++ )
		{
			$return[] = array( $y, $y);
		}
		
		return $return;
	}
	
	//+----------------------------------------
	
	function make_month()
	{
		$return = array();
		
		for ( $m = 1 ; $m <= 12; $m++ )
		{
			$return[] = array( $m, $this->month_names[$m] );
		}
		
		return $return;
	}
	
	//+----------------------------------------
	
	function make_day()
	{
		$return = array();
		
		for ( $d = 1 ; $d <= 31; $d++ )
		{
			$return[] = array( $d, $d );
		}
		
		return $return;
	}
	
	
		
}


?>
